<?php defined('SYSPATH') or die('No direct script access.');

class Create_problems_table extends Migration
{
    public $schema = 'public';
    public $table = 'problems';

    public function up()
    {
        $this->create_table($this->table,
            [
                'server' => ['string', 'length' => 64, 'null' => false],
                'filename' => ['string', 'length' => 255, 'null' => false],
                'logline' => ['text', 'null' => false],
                'level' => ['integer', 'unsigned' => true, 'null' => false, 'default' => 0],
                'description' => ['text', 'null' => true],
                'created_at' => ['datetime', 'null' => false],
                'deleted_at' => ['datetime', 'null' => true],
            ]
        );
        $this->add_index($this->table, 'problems_server_filename_idx', ['server', 'filename'], 'normal');
        $this->add_index($this->table, 'problems_level_idx', ['level'], 'normal');
        $this->add_index($this->table, 'problems_created_at_idx', ['deleted_at'], 'normal');
        $this->add_index($this->table, 'problems_deleted_at_idx', ['deleted_at'], 'normal');
    }

    public function down()
    {
        $this->drop_table($this->table);
    }
}